/*
 * Decompiled with CFR 0.152.
 */
package wafflestomper.ghostwriter.gui.screen;

import java.io.File;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import wafflestomper.ghostwriter.Ghostwriter;
import wafflestomper.ghostwriter.gui.GhostLayer;
import wafflestomper.ghostwriter.gui.GuiUtils;
import wafflestomper.ghostwriter.gui.widget.FileSelectionList;
import wafflestomper.ghostwriter.gui.widget.SelectableFilenameField;
import wafflestomper.ghostwriter.utilities.Clipboard;
import wafflestomper.ghostwriter.utilities.FileHandler;
import wafflestomper.ghostwriter.utilities.Printer;

public class GhostwriterFileBrowserScreen
extends Screen {
    private FileSelectionList fileSelectionList;
    private SelectableFilenameField filenameField;
    private boolean directoryDirty = false;
    private File cachedPath;
    private File selectedFile = null;
    private final GhostLayer parent;
    private final Clipboard TEMP_CLIPBOARD = new Clipboard();
    private static final Printer PRINTER = new Printer();
    private final FileHandler FILE_HANDLER;
    private static final int BORDER_HEIGHT = 2;
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SLOT_HEIGHT = 12;
    private static final int DISPLAY_PATH_WIDTH = 200;
    private Button btnAutoReload;
    private Button btnLoad;
    private Button btnSave;
    private Button btnEditExtension;
    private boolean initialized = false;
    private boolean enableLoading = false;
    private String hoveringText;

    public GhostwriterFileBrowserScreen(GhostLayer parent) {
        super((Component)Component.m_237115_((String)"Ghostwriter File Browser"));
        this.parent = parent;
        this.FILE_HANDLER = new FileHandler(this.TEMP_CLIPBOARD);
        if (Ghostwriter.currentPath == null) {
            Ghostwriter.currentPath = this.FILE_HANDLER.getSavePath();
        }
        this.FILE_HANDLER.currentPath = Ghostwriter.currentPath;
        if (parent.bookIsEditable) {
            this.enableLoading = true;
        }
    }

    private void driveButtonClicked(File root) {
        this.FILE_HANDLER.currentPath = root;
    }

    public void saveCallback(boolean confirmed) {
        if (confirmed) {
            this.saveBook();
        } else {
            this.goBackToParentGui();
        }
    }

    private void loadClicked(boolean autoReload) {
        if (!this.TEMP_CLIPBOARD.bookInClipboard) {
            PRINTER.gamePrint(Printer.RED + "Error loading book - no book in temp clipboard!");
        } else if (!this.parent.bookIsEditable) {
            PRINTER.gamePrint(Printer.RED + "Error loading book - you can't load to a non-writable book!");
        }
        if (autoReload) {
            this.parent.enableAutoReload(this.FILE_HANDLER.lastLoadedBook, this.TEMP_CLIPBOARD);
            this.parent.clipboardToBook(this.TEMP_CLIPBOARD);
        } else {
            Ghostwriter.GLOBAL_CLIPBOARD.clone(this.TEMP_CLIPBOARD);
            new Printer().gamePrint(Printer.GRAY + "Book loaded into clipboard");
        }
        this.goBackToParentGui();
    }

    private void saveClicked() {
        File save_path = new File(this.FILE_HANDLER.currentPath, this.filenameField.m_94155_());
        if (save_path.exists()) {
            MutableComponent overwriteText = Component.m_237115_((String)"Are you sure you wish to overwrite this file?");
            MutableComponent filenameText = Component.m_237115_((String)this.filenameField.m_94155_());
            MutableComponent s1 = Component.m_237115_((String)"Yes");
            MutableComponent s2 = Component.m_237115_((String)"Cancel");
            Ghostwriter.currentPath = this.FILE_HANDLER.currentPath;
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_((Screen)new ConfirmScreen(this::saveCallback, (Component)overwriteText, (Component)filenameText, (Component)s1, (Component)s2));
        } else {
            this.saveBook();
        }
    }

    public void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ == null) {
            return;
        }
        if (!this.initialized) {
            this.fileSelectionList = new FileSelectionList(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 64, 12);
            this.filenameField = new SelectableFilenameField(this.f_96541_.f_91062_, this.f_96543_ / 2 - 125, this.f_96544_ - 2 - 20, 250, 20, (Component)Component.m_237115_((String)"filename"));
            this.filenameField.m_94199_(100);
            String file_title = this.parent.getBookTitle();
            String file_author = this.parent.getBookAuthor();
            file_title = file_title.trim().replaceAll(" ", ".").replaceAll("[^a-zA-Z0-9.]", "");
            file_author = file_author.trim().replaceAll(" ", ".").replaceAll("[^a-zA-Z0-9.]", "");
            String defaultFilename = file_title + "_" + file_author + "_" + this.FILE_HANDLER.getUTC() + ".ghb";
            this.filenameField.m_94144_(defaultFilename);
            this.filenameField.m_93692_(true);
            this.filenameField.highlightFilename();
            this.initialized = true;
        }
        int mainButtonsY = this.f_96544_ - 2 - 20;
        int loadX = this.f_96543_ / 2 - 127;
        this.btnLoad = (Button)this.m_142416_((GuiEventListener)GuiUtils.buttonFactory(loadX, mainButtonsY, 60, 20, "Load", pressedButton -> this.loadClicked(false)));
        int autoReloadX = loadX + 60;
        this.btnAutoReload = (Button)this.m_142416_((GuiEventListener)GuiUtils.buttonFactory(autoReloadX, mainButtonsY, 60, 20, "AutoReload", pressedButton -> this.loadClicked(true)));
        int saveX = autoReloadX + 60 + 7;
        this.btnSave = (Button)this.m_142416_((GuiEventListener)GuiUtils.buttonFactory(saveX, mainButtonsY, 60, 20, "Save", pressedButton -> this.saveClicked()));
        int cancelX = this.f_96543_ / 2 + 127 - 60;
        this.m_142416_((GuiEventListener)GuiUtils.buttonFactory(cancelX, mainButtonsY, 60, 20, "Cancel", pressedButton -> this.goBackToParentGui()));
        int rootNum = 100;
        List<File> roots = this.FILE_HANDLER.getValidRoots();
        for (File root : roots) {
            this.m_142416_((GuiEventListener)GuiUtils.buttonFactory(5, 35 + 21 * (rootNum - 100), 50, 20, root.getAbsolutePath(), pressedButton -> this.driveButtonClicked(root)));
            ++rootNum;
        }
        this.f_96540_.add(this.fileSelectionList);
        this.populateFileList();
        this.fileSelectionList.m_93437_(this.f_96543_, this.f_96544_, 32, this.f_96544_ - 64);
        this.filenameField.f_93620_ = this.f_96543_ / 2 - 125;
        this.filenameField.f_93621_ = this.f_96544_ - 4 - 40;
        this.btnEditExtension = (Button)this.m_142416_((GuiEventListener)GuiUtils.buttonFactory(this.filenameField.f_93620_ + this.filenameField.m_5711_() + 3, this.filenameField.f_93621_, 25, this.filenameField.m_93694_(), "EXT", pressedButton -> {
            this.filenameField.toggleExtensionModifications();
            this.updateButtons();
        }));
        this.updateButtons();
    }

    public void setDirectoryDirty() {
        this.directoryDirty = true;
    }

    public void navigateUp() {
        this.FILE_HANDLER.navigateUp();
        this.directoryDirty = true;
    }

    private boolean isFilenameValid() {
        String fn = this.filenameField.m_94155_();
        return !fn.isEmpty();
    }

    @ParametersAreNonnullByDefault
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.btnSave.f_93623_ = this.isFilenameValid();
        this.hoveringText = null;
        this.fileSelectionList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        Object displayPath = this.FILE_HANDLER.currentPath.getAbsolutePath();
        int displayPathSize = this.f_96547_.m_92895_((String)displayPath);
        if (displayPathSize > 200) {
            int allowedSize = 200 - this.f_96547_.m_92895_("...");
            String reversed = new StringBuilder((String)displayPath).reverse().toString();
            reversed = this.f_96547_.m_92865_().m_92410_(reversed, allowedSize, Style.f_131099_);
            displayPath = "..." + new StringBuilder(reversed).reverse();
        }
        guiGraphics.m_280137_(this.f_96547_, (String)displayPath, this.f_96543_ / 2, 20, 0xDDDDDD);
        this.filenameField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (mouseX >= this.f_96543_ / 2 - 100 && mouseX <= this.f_96543_ / 2 + 100 && mouseY >= 20 && mouseY <= 27) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)displayPath), 0, 0);
        } else if (this.hoveringText != null) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)this.hoveringText), mouseX, mouseY);
        }
    }

    public void setSelectedSlot(FileSelectionList.Entry entry) {
        this.fileSelectionList.m_6987_((AbstractSelectionList.Entry)entry);
        if (this.enableLoading && entry instanceof FileSelectionList.PathItemEntry) {
            FileSelectionList.PathItemEntry p = (FileSelectionList.PathItemEntry)entry;
            if (p.path == this.selectedFile) {
                return;
            }
            if (p.path.isFile()) {
                this.FILE_HANDLER.loadBook(p.path);
                this.selectedFile = p.path;
                this.filenameField.m_94144_(p.path.getName());
                this.updateButtons();
                return;
            }
        }
        this.TEMP_CLIPBOARD.clearBook();
        this.selectedFile = null;
        this.updateButtons();
    }

    public void m_86600_() {
        this.filenameField.m_94120_();
        this.btnSave.f_93623_ = this.isFilenameValid();
        if (this.FILE_HANDLER.currentPath != this.cachedPath) {
            this.directoryDirty = true;
            this.populateFileList();
        }
        super.m_86600_();
    }

    public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        this.filenameField.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        return super.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    private void populateFileList() {
        this.fileSelectionList.updateFileList(this.FILE_HANDLER.listFiles(this.FILE_HANDLER.currentPath, this.directoryDirty));
        this.directoryDirty = false;
        this.cachedPath = this.FILE_HANDLER.currentPath;
    }

    private void goBackToParentGui() {
        if (this.f_96541_ == null) {
            return;
        }
        Ghostwriter.currentPath = this.FILE_HANDLER.currentPath;
        this.f_96541_.m_91152_(this.parent.screen);
    }

    public void updateButtons() {
        if (this.enableLoading) {
            this.btnLoad.f_93623_ = this.TEMP_CLIPBOARD.bookInClipboard;
            this.btnAutoReload.f_93623_ = this.TEMP_CLIPBOARD.bookInClipboard;
        } else {
            this.btnAutoReload.f_93623_ = false;
            this.btnAutoReload.f_93624_ = false;
            this.btnLoad.f_93623_ = false;
            this.btnLoad.f_93624_ = false;
        }
        if (this.filenameField.allowExtensionModifications) {
            this.btnEditExtension.m_93666_((Component)Component.m_237115_((String)"EXT"));
        } else {
            this.btnEditExtension.m_93666_((Component)Component.m_237115_((String)"\u00a7mEXT"));
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.goBackToParentGui();
            return true;
        }
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        this.TEMP_CLIPBOARD.clearBook();
        this.updateButtons();
        return this.filenameField.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char p_charTyped_1_, int p_charTyped_2_) {
        if (super.m_5534_(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return this.filenameField.m_5534_(p_charTyped_1_, p_charTyped_2_);
    }

    private File getSavePath() {
        return new File(this.FILE_HANDLER.currentPath, this.filenameField.m_94155_());
    }

    private void saveBook() {
        this.parent.saveBookToDisk(this.getSavePath());
        this.goBackToParentGui();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.filenameField.m_6375_(mouseX, mouseY, mouseButton);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void navigateInto(File path) {
        if (path.isFile()) {
            if (this.TEMP_CLIPBOARD.bookInClipboard) {
                this.loadClicked(false);
            }
        } else {
            this.FILE_HANDLER.currentPath = path;
        }
    }

    public void setHoveringText(String text) {
        this.hoveringText = text;
    }
}

